<?php

/**
 *
 * @link       https://advancedplugins.com
 * @since      1.1.2
 * @author     Your Name office@advancedplugins.com
 */

class Advanced_Speed_Optimizer_Admin {


	private $Advanced_Speed_Optimizer;
	public static $module_pages = array(
    								'advanced-speed-optimizer-image-compression', 
    								'advanced-speed-optimizer-quality-test', 
    								'advanced-speed-optimizer-restore-backup', 
    								'advanced-speed-optimizer-activation', 
    								'advanced-speed-optimizer-image-webp',
    								'advanced-speed-optimizer-image-optimizations',
    								'advanced-speed-optimizer-lazy-load',
    								'advanced-speed-optimizer',
    								'advanced-speed-optimizer-documentation',
    								'advanced-speed-optimizer-support'
    							);

	/**
	 * The version of this plugin.
	 *
	 * @since    1.1.2
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.1.2
	 * @param      string    $Advanced_Speed_Optimizer       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $Advanced_Speed_Optimizer, $version ) {

		$this->Advanced_Speed_Optimizer = $Advanced_Speed_Optimizer;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.1.2
	 */
	public function enqueue_styles() {

		/**
		 * Add CSS to the backoffice
		 */

		 if(isset($_GET['page']))
    	 {
    		if( in_array( $_GET['page'], Advanced_Speed_Optimizer_Admin::$module_pages ))
    		{
				wp_enqueue_style(  $this->Advanced_Speed_Optimizer.'-bootstrap', plugin_dir_url( __FILE__ ) . 'css/bootstrap.min.css', array(), 'all' );
				wp_enqueue_style( $this->Advanced_Speed_Optimizer, plugin_dir_url( __FILE__ ) . 'css/advanced-speed-optimizer-admin.css', array(), $this->version, 'all' );
			}
		}
	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.1.2
	 */
	public function enqueue_scripts() {

		/**
		 * Add Js to the backoffice
		 */


    	if(isset($_GET['page']))
    	{
    		if( in_array( $_GET['page'], Advanced_Speed_Optimizer_Admin::$module_pages ))
    		{

    			wp_enqueue_script( $this->Advanced_Speed_Optimizer.'-bootstrap', plugin_dir_url( __FILE__ ) . 'js/bootstrap.min.js', array('jquery'), $this->version, true );
    			wp_enqueue_script( $this->Advanced_Speed_Optimizer.'-common', plugin_dir_url( __FILE__ ) . 'js/advanced-speed-optimizer-admin.js', array( 'jquery' ), $this->version, false );

    			wp_enqueue_script( $this->Advanced_Speed_Optimizer.'-compression', plugin_dir_url( __FILE__ ) . 'js/advanced-speed-optimizer-image-compression.js', array( 'jquery' ), $this->version, false );
				wp_localize_script( $this->Advanced_Speed_Optimizer.'-compression', 'Advanced_Speed_Optimizer', array( 
																									'ajax_url' => admin_url( 'admin-ajax.php' ),
																									'aso_root_dir' => rtrim(get_home_path(),'/'),
																									'aso_domain_url' =>  rtrim(get_site_url(),'/'),
																									'confirmation_compress' => esc_html__('Changes are irreversible, we recommended backing up your images before you compress them! Are you sure you want to continue?', Advanced_Speed_Optimizer::$plugin_slug)
																								)
								);

    		}
    	}
	}

	public static function filter_wp_generate_attachment_metadata($metadata, $attachment_id )
	{
		$valid  = true;
		$aso_cc_active = (int)get_option('aso_cc_active', 0);

		if( $aso_cc_active != 1)
			return $metadata;

		if(isset($_GET['action']))
		{
			if($_GET['action'] == 'aso_restore_images')
				$valid = false;
		}

		/*
		if (defined('DOING_AJAX') && DOING_AJAX) { 
			$valid = false; 
		}

		if(function_exists('wp_doing_ajax')){
			if(wp_doing_ajax()){
				$valid = false;	
			}
		}
		*/

		if(
			((int)get_option('compress_future_images', 0) == 0 && get_option('convert_future_images', 0) == 0) || !isset($metadata['image_meta']) || !isset($metadata['sizes']) || !$valid
		)
			return $metadata;

		if(get_option('compress_future_images', 0) == 1)
			Advanced_Speed_Optimizer_Functions::compress_all_sizes_of_image($attachment_id);

		if(get_option('convert_future_images', 0) == 1)
			Advanced_Speed_Optimizer_Functions::convert_all_sizes_of_image($attachment_id);

		return  $metadata;
	}

	/**
	 * Register the Menus for the admin area.
	 *
	 * @since    1.1.2
	 */

	public function insert_menus() {

		/**
		 * Create the backoffice admin menus
		*/

		add_menu_page(Advanced_Speed_Optimizer::$plugin_name, Advanced_Speed_Optimizer::$plugin_name, 'manage_options', Advanced_Speed_Optimizer::$plugin_slug, array($this, 'documentation'));
		add_submenu_page( Advanced_Speed_Optimizer::$plugin_slug, __('Quality test', Advanced_Speed_Optimizer::$plugin_slug),  __('Quality test', Advanced_Speed_Optimizer::$plugin_slug), 'manage_options', Advanced_Speed_Optimizer::$plugin_slug.'-quality-test', array($this, 'quality_test'));
		add_submenu_page( Advanced_Speed_Optimizer::$plugin_slug, __('Compression', Advanced_Speed_Optimizer::$plugin_slug),  __('Compression', Advanced_Speed_Optimizer::$plugin_slug), 'manage_options', Advanced_Speed_Optimizer::$plugin_slug.'-image-compression', array($this, 'image_compression'));
		add_submenu_page( Advanced_Speed_Optimizer::$plugin_slug, __('WebP', Advanced_Speed_Optimizer::$plugin_slug),  __('WebP', Advanced_Speed_Optimizer::$plugin_slug), 'manage_options', Advanced_Speed_Optimizer::$plugin_slug.'-image-webp', array($this, 'image_webp'));
		add_submenu_page( Advanced_Speed_Optimizer::$plugin_slug, __('Lazy load', Advanced_Speed_Optimizer::$plugin_slug),  __('Lazy load', Advanced_Speed_Optimizer::$plugin_slug), 'manage_options', Advanced_Speed_Optimizer::$plugin_slug.'-lazy-load', array($this, 'lazy_load'));
		add_submenu_page( Advanced_Speed_Optimizer::$plugin_slug, __('Optimizations', Advanced_Speed_Optimizer::$plugin_slug),  __('Optimizations', Advanced_Speed_Optimizer::$plugin_slug), 'manage_options', Advanced_Speed_Optimizer::$plugin_slug.'-image-optimizations', array($this, 'image_optimizations'));
		add_submenu_page( Advanced_Speed_Optimizer::$plugin_slug, __('Backups', Advanced_Speed_Optimizer::$plugin_slug),  __('Backups', Advanced_Speed_Optimizer::$plugin_slug), 'manage_options', Advanced_Speed_Optimizer::$plugin_slug.'-restore-backup', array($this, 'restore_backup'));
		add_submenu_page( Advanced_Speed_Optimizer::$plugin_slug, __('Activation', Advanced_Speed_Optimizer::$plugin_slug),  __('Activation', Advanced_Speed_Optimizer::$plugin_slug), 'manage_options', Advanced_Speed_Optimizer::$plugin_slug.'-activation', array($this, 'activation'));
		add_submenu_page( Advanced_Speed_Optimizer::$plugin_slug, __('Support', Advanced_Speed_Optimizer::$plugin_slug),  __('Support', Advanced_Speed_Optimizer::$plugin_slug), 'manage_options', Advanced_Speed_Optimizer::$plugin_slug.'-support', array($this, 'support'));

	}
 

 	public function lazy_load()
 	{
		require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/common/top-menu.php');
	    require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/'.Advanced_Speed_Optimizer::$plugin_slug.'-lazy-load.php');
	    require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/common/footer.php');
	
 	}

 	public function default_page()
 	{
	    require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/'.Advanced_Speed_Optimizer::$plugin_slug.'-image-compression.php');
	    require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/common/footer.php');

	}

	public function restore_backup()
	{
		require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/common/top-menu.php');
	    require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/'.Advanced_Speed_Optimizer::$plugin_slug.'-restore-backup.php');
	    require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/common/footer.php');
	}

	public function image_optimizations()
	{
		require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/common/top-menu.php');
	    require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/'.Advanced_Speed_Optimizer::$plugin_slug.'-image-optimizations.php');
	    require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/common/footer.php');

	}


	public function support()
	{
		require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/common/top-menu.php');
	    require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/'.Advanced_Speed_Optimizer::$plugin_slug.'-support.php');
	    require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/common/footer.php');

	}

	public function image_compression()
	{
		require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/common/top-menu.php');
	    require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/'.Advanced_Speed_Optimizer::$plugin_slug.'-image-compression.php');
	    require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/common/footer.php');
	}

	public function activation()
	{
		require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/common/top-menu.php');
	    require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/'.Advanced_Speed_Optimizer::$plugin_slug.'-activation.php');
	    require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/common/footer.php');
	}


	public function image_webp()
	{
		require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/common/top-menu.php');
	    require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/'.Advanced_Speed_Optimizer::$plugin_slug.'-webp.php');
	    require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/common/footer.php');
	}


	public function quality_test(){

		/**
		 * Loads the Test Quality View
		*/
		
 		require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/common/top-menu.php');
	    require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/'.Advanced_Speed_Optimizer::$plugin_slug.'-quality-test.php');
	    require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/common/footer.php');

	}

	public function documentation(){

		/**
		 * Loads the Documentation View
		*/

		require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/common/top-menu.php');
	    require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/'.Advanced_Speed_Optimizer::$plugin_slug.'-documentation.php');
	    require_once(Advanced_Speed_Optimizer_Plugin_Path.'/admin/partials/common/footer.php');

	}

}
