<?php 
/**
 *
 * @link       https://advancedplugins.com
 * @since      1.1.2
 * @author     Your Name office@advancedplugins.com
 */
	/* Get the neccesary data */

	$all_image_sizes = Advanced_Speed_Optimizer_Functions::get_all_image_sizes();
	$compress_future_images = (int)get_option('compress_future_images', 0);
	$compression_quality_arr = array(60,70,75,80,85,90,91,92,93,94,95,96,97,98,99,100);
	$compression_quality = (int)get_option('compression_quality', 70);
	$compression_backup = (int)get_option('compression_backup', 0);
	
	global $optimize_info;
	$optimize_info = array('type' => 'compress', 'title' => 'Compress');

?>

<div id="ap-image-compression" class="ap_wrapper bootstrap  ">
   <div class="tab-content ">
      <div id="regenerate" class="tab-pane active">

	<div class="panel">
		   <div class="panel-heading"><?php esc_html_e('Settings', Advanced_Speed_Optimizer::$plugin_name ) ?></div>
				<div class="alert alert-warning">
					<p><strong><?php esc_html_e('Important', Advanced_Speed_Optimizer::$plugin_name ) ?></strong></p>
					<hr>
					<p><strong><?php esc_html_e('Please read the documentation before you compress the images to understand the optimal process to compress the images, you can do this by pressing the `Documentation` button in the plugin menu', Advanced_Speed_Optimizer::$plugin_name ) ?></strong></p>
					<p><?php esc_html_e('The compression process cannot be reverted, the only way to remake the picture in case of quality loss is to regenerate the image sizes.', Advanced_Speed_Optimizer::$plugin_name ) ?></p>
					<p><?php esc_html_e('Make sure you are satisfied with the image quality on image sizes before you compress the original image as that cannot be reverted', Advanced_Speed_Optimizer::$plugin_name ) ?></p>
					<p><?php esc_html_e('It is highly encouraged you backup your images before compression as a fail safe but make sure you have enough free disk space (the backup will take the same space as the original images + image sizes have)! ', Advanced_Speed_Optimizer::$plugin_name ) ?></p>
					
				</div>
		   		<div class="clear"></div>
				<table class="table">
			    	<tbody>
			    		<tr>
				    		<td>
				    			<label class="labelbutton"><?php esc_html_e('Compress future images', Advanced_Speed_Optimizer::$plugin_name ) ?></label>
				    		</td>
				    		<td>
								<label class="switch">
								  <input type="checkbox" class="update_option_switch" name="compress_future_images" value="1" <?php if($compress_future_images == 1): ?> checked<?php endif; ?>>
								  <span class="slider round "></span>
								</label>
				    		</td>
				    		<td><small><?php esc_html_e('With this option active, future images will automatically be compressed when uploaded, this will slow down your image upload process so turn this off when mass importing or it may cause timeout', Advanced_Speed_Optimizer::$plugin_name ) ?></small></td>
			    		</tr>
			    		<tr>
				    		<td>
				    			<label class="labelbutton"><?php esc_html_e('Compression backup', Advanced_Speed_Optimizer::$plugin_name ) ?></label>
				    		</td>
				    		<td>
								<label class="switch">
								  <input type="checkbox" class="update_option_switch" name="compression_backup" value="1" <?php if($compression_backup == 1): ?> checked<?php endif; ?>>
								  <span class="slider round "></span>
								</label>
				    		</td>
				    		<td><small><?php esc_html_e('With this option active, future images will automatically be backed up before they are compressed, but it will almost double the space taken on your server, but it will allow you to restore them in case of you over optimize the images.', Advanced_Speed_Optimizer::$plugin_name ) ?></small></td>
			    		</tr>
			    		<tr>
				    		<td>
				    			<label class="labelbutton"><?php esc_html_e('Compression quality', Advanced_Speed_Optimizer::$plugin_name ) ?></label>
				    		</td>
				    		<td>
				    			<select name="compression_quality" class="update_option_select">
				    				<?php foreach($compression_quality_arr as $cqa): ?>
				    					<option value="<?php echo  esc_attr($cqa) ?>" <?php if($cqa == $compression_quality ) echo 'selected'; ?>><?php esc_html_e($cqa) ?>%</option>
				    				<?php endforeach; ?>
				    			</select>
							
				    		</td>
				    		<td><small><?php esc_html_e('The quality used to compress the image, a lower quality means more space saved but at the cost of image quality, usually 80% is the optimal image quality but be certain, go to the `Quality Test` menu.', Advanced_Speed_Optimizer::$plugin_name ) ?></small></td>
			    		</tr>
			    	</tbody>
				</table>
   			</div>

         <div class=" panel">
         	<div class="alert alert-info">
					<p><strong><?php esc_html_e('Why are existing images compressed manually?', Advanced_Speed_Optimizer::$plugin_name ) ?></strong></p>
					<hr>
					<ul>
						<li><small>- <?php esc_html_e('To allow the compression at a different quality if the user considers it neccesary or has changed his mind (If the old compression quality is smaller than the new one, there will be no changes)', Advanced_Speed_Optimizer::$plugin_name ) ?></small></li>
						<li><small>- <?php esc_html_e('On most servers if the site has many images the PHP would reach it`s max execution time and timeout, as it can take hours for big images catalogs to be compressed; imagine, if you have 1000 images and 10 image sizes for each image there would be 10.000 images to compress.', Advanced_Speed_Optimizer::$plugin_name ) ?></small></li>
					</ul>
					
				</div>

            <div class="panel-heading"><i class="icon-minus"></i> <?php esc_html_e('Compress existing media images', Advanced_Speed_Optimizer::$plugin_name ) ?></div>
            <table class="table process_compress">
               <thead>
                  <tr class="first">
                     <th width="30">
                        <div class="md-checkbox">
                           <label class="col-lg-12">
                           <input type="checkbox" class="check_all_inputs form-check-input" checked="">
                           <i class="md-checkbox-control"></i>
                           </label>
                        </div>
                     </th>
                     <th class="mw200"><?php esc_html_e('Type', Advanced_Speed_Optimizer::$plugin_name ) ?></th>
                     <th class="w62p"  class=""><?php esc_html_e('Status', Advanced_Speed_Optimizer::$plugin_name ) ?></th>
                     <th class="tar mw100"><?php esc_html_e('Complete', Advanced_Speed_Optimizer::$plugin_name ) ?></th>
                     <th class="tar mw100"><?php esc_html_e('Saved space', Advanced_Speed_Optimizer::$plugin_name ) ?></th>
                  </tr>
               </thead>
               <tbody>
               	  <?php if($all_image_sizes): ?>
               	  	<?php foreach($all_image_sizes as $k => $img): ?>
		                  <tr class="tr_product_compress image_tr_<?php echo  esc_attr($k) ?>">
		                     <td>
		                        <div class="md-checkbox">
		                           <label class="col-lg-12">
		                           <input type="checkbox" class="check_image_compression form-check-input" <?php if($k != 'original'): ?>checked=""<?php endif; ?> value="<?php echo  esc_attr($k) ?>">
		                           <i class="md-checkbox-control"></i>
		                           </label>
		                          
		                           <input type="hidden" class="name_image_type" value="<?php echo  esc_attr($k) ?>">
		                        </div>
		                     </td>
		                     <td><?php esc_html_e($k) ?></td>
		                     <td>
		                        <div class="progress" max="<?php echo  esc_attr($img['count']) ?>">
		                           <div class="progress-bar process_product_compress" role="progressbar" style="width: <?php echo  esc_attr($img['percent_done']) ?>%;">
		                           </div>
		                        </div>
		                     </td>
		                     <td   class="tar">
		                        <span class="status_product_compress"><?php esc_html_e($img['percent_done']) ?></span>% | 
		                        <span class="complete_product_compress">
		                        <span class="total_product_success_compress">
		                        	<?php esc_html_e($img['compressed_count']) ?>
		                        </span> /
		                        <span class="total_image_product_compress">
		                        <?php esc_html_e($img['count']) ?>
		                        </span>
		                        </span>
		                     </td>
		                     <td   class="tar"><span class="compressed_saved"><?php esc_html_e($img['compressed_saved']) ?></span> <?php esc_html_e('Kb', Advanced_Speed_Optimizer::$plugin_name ) ?></td>
		                  </tr>
              		<?php endforeach; ?>
					<tr>
						<td colspan="3">
							<div class="status_bar_image">
								<div class="lds-ellipsis compress_loading"><div></div><div></div><div></div><div></div></div>
								<button type="button" class="btn btn-default btn-custom compress_image ap_compress_image"><i class="icon-refresh"></i> <?php esc_html_e('Compress', Advanced_Speed_Optimizer::$plugin_name ) ?></button>
								<button type="button" class="btn btn-danger btn-stop stop_compress ap_stop_compress"><i class="icon-stop"></i><?php esc_html_e('Stop Compress', Advanced_Speed_Optimizer::$plugin_name ) ?></button>
							</div>
						</td>
						<td></td>
						<td    class="tar">
							<div class="status_bar_image">
								<button type="button" class="btn btn-danger btn-stop reset_compress ap_reset_compress"><div alt="f531" class="dashicons dashicons-image-rotate"></div><?php esc_html_e('Reset', Advanced_Speed_Optimizer::$plugin_name ) ?></button>
							</div>
						</td>
					</tr>
              	<?php endif; ?>

               </tbody>
            </table>
         </div>
      <div class="clear" style="clear:both"></div>
      <?php  require_once('advanced-speed-optimizer-folder.php');  ?>
      <div class="clear" style="clear:both"></div>
   </div>
   <div class="clear" style="clear:both"></div>
</div>