<?php 
/**
 *
 * @link       https://advancedplugins.com
 * @since      1.1.2
 * @author     Your Name office@advancedplugins.com
 */
	/* Get the neccesary data */

	$compression_quality_arr = array(60,70,75,80,85,90,91,92,93,94,95,96,97,98,99,100);
	$compression_quality = (int)get_option('compression_quality', 70);

?>

<div id="ap-image-compression" class="ap_wrapper bootstrap  ">
   <div class="tab-content ">
      <div id="regenerate" class="tab-pane active">

	<div class="panel">
		   <div class="panel-heading"><?php esc_html_e('Quality test', Advanced_Speed_Optimizer::$plugin_name ) ?></div>
				<div class="alert alert-warning">
					<p><strong><?php esc_html_e('Important', Advanced_Speed_Optimizer::$plugin_name ) ?></strong></p>
					<hr>
					<p><?php esc_html_e('In this section, you will can test every quality percent you want to make sure you will apply the right one to your stored images.', Advanced_Speed_Optimizer::$plugin_name ) ?></p>
					<p><?php esc_html_e('Do not be afraid to select lower quality percents as no compression if applied to your own files, this is only for testing purposes.', Advanced_Speed_Optimizer::$plugin_name ) ?></p>
					<p><?php esc_html_e('Please take into account, if your images have already been compressed at the selected quality or a lower one, the saved space will be 0.', Advanced_Speed_Optimizer::$plugin_name ) ?></p>
				</div>
		   		<div class="clear"></div>
				<table class="table">
			    	<tbody>
			    		<tr>
				    		<td>
				    			<label class="labelbutton"><?php esc_html_e('Compression quality', Advanced_Speed_Optimizer::$plugin_name ) ?></label>
				    		</td>
				    		<td>
				    			<select name="compression_quality" id="ap_quality_test">
				    				<?php foreach($compression_quality_arr as $cqa): ?>
				    					<option value="<?php echo  esc_attr($cqa) ?>" <?php if($cqa == $compression_quality ) echo 'selected'; ?>><?php esc_html_e($cqa) ?>%</option>
				    				<?php endforeach; ?>
				    			</select>
							
				    		</td>
				    		<td><small><?php esc_html_e('The quality used to compress the image, a lower quality means more space saved but at the cost of image quality, usually 80% is the optimal image quality', Advanced_Speed_Optimizer::$plugin_name ) ?></small></td>
			    		</tr>
			    		<tr>
			    			<td colspan="3">
			    				<button type="button" class="btn btn-default btn-custom  ap_quality_test"><i class="icon-refresh"></i> <?php esc_html_e('Generate quality preview', Advanced_Speed_Optimizer::$plugin_name ) ?></button>
			    			</td>
			    		</tr>
			    	</tbody>
				</table>
   			</div>

         <div class=" panel">
            <div class="panel-heading"><i class="icon-minus"></i> <?php esc_html_e('Image quality preview', Advanced_Speed_Optimizer::$plugin_name ) ?></div>
            <table class="table process_compress">
               <thead>
                  <tr class="first">
                     <th><?php esc_html_e('Original image', Advanced_Speed_Optimizer::$plugin_name ) ?></th>
                     <th><?php esc_html_e('Compressed image', Advanced_Speed_Optimizer::$plugin_name ) ?></th>
                  </tr>
               </thead>
               <tbody  class="quality_results">
               	
               		<tr class="quality_test_no_results">
               			<td colspan="2"><?php esc_html_e('No preview is available, you must select the desired quality from the above dropdown and press the `Generate quality preview` button.', Advanced_Speed_Optimizer::$plugin_name ) ?></td>
               		</tr>
               	 	
               </tbody>
            </table>
         </div>
      <div class="clear" style="clear:both"></div>
   </div>
   <div class="clear" style="clear:both"></div>
</div>