<?php

/**
 *
 * @link       https://advancedplugins.com
 * @since      1.1.2
 * @author     Your Name office@advancedplugins.com
 */



class Advanced_Speed_Optimizer_Functions {



	public static function getDirContents($root) 
	{
		$iter = new RecursiveIteratorIterator(
		    new RecursiveDirectoryIterator($root, RecursiveDirectoryIterator::SKIP_DOTS),
		    RecursiveIteratorIterator::SELF_FIRST,
		    RecursiveIteratorIterator::CATCH_GET_CHILD // Ignore "Permission denied"
		);

		$paths = array($root);

		foreach ($iter as $path => $dir) 
		{
		    if ($dir->isDir()) 
		    {
		        $paths[] = $path;
		    }
		}

		return $paths;
	}


	public static function getAllImgs($directory, $type = '', $is_webp = false)
	{
		  $resizedFilePath = array();
		  $imagewebp = function_exists('imagewebp');

		  foreach ($directory AS $dir) 
		  {
		    foreach (glob($dir . '/*'.$type.'.jpg') as $filename) 
		        array_push($resizedFilePath, $filename);

		    foreach (glob($dir . '/*'.$type.'.png') as $filename) 
		        array_push($resizedFilePath, $filename);

		   	foreach (glob($dir . '/*'.$type.'.PNG') as $filename) 
		        array_push($resizedFilePath, $filename);
		    
		    foreach (glob($dir . '/*'.$type.'.jpeg') as $filename) 
		        array_push($resizedFilePath, $filename);
		    
		    foreach (glob($dir . '/*'.$type.'.JPEG') as $filename) 
		        array_push($resizedFilePath, $filename);

		    foreach (glob($dir . '/*'.$type.'.JPG') as $filename) 
		        array_push($resizedFilePath, $filename);
		    		
		    foreach (glob($dir . '/*'.$type.'.jpg') as $filename) 
		        array_push($resizedFilePath, $filename);

		    
		    if($is_webp)
		    {
		   		 foreach (glob($dir . '/*'.$type.'.webp') as $filename) 
		        	array_push($resizedFilePath, $filename);
		    }

		}

		return $resizedFilePath;
	}

	public static function get_all_image_sizes() {

	    global $_wp_additional_image_sizes;

	    $default_image_sizes = get_intermediate_image_sizes();

	    foreach ( $default_image_sizes as $size ) {
	        $image_sizes[ $size ][ 'width' ] = intval( get_option( "{$size}_size_w" ) );
	        $image_sizes[ $size ][ 'height' ] = intval( get_option( "{$size}_size_h" ) );
	        $image_sizes[ $size ][ 'crop' ] = get_option( "{$size}_crop" ) ? get_option( "{$size}_crop" ) : false;
	    }

	    if ( isset( $_wp_additional_image_sizes ) && count( $_wp_additional_image_sizes ) ) {
	        $image_sizes = array_merge( $image_sizes, $_wp_additional_image_sizes );
	    }

	    $count = self::attachment_count();

	    if($image_sizes) {
	    	$image_sizes['original'] = array(1);
	    	foreach ($image_sizes as $k => $v) {
	    		$image_sizes[$k]['count'] = $count;
	    		$image_sizes[$k]['compressed_count'] = (int)get_option('compressed_offset_'.$k, 0);
	    		$image_sizes[$k]['restored_count'] = (int)get_option('restored_offset_'.$k, 0);
	    		$image_sizes[$k]['webp_count'] = (int)get_option('webp_offset_'.$k, 0);
	    		if($image_sizes[$k]['webp_count'] > $count )
	    			$image_sizes[$k]['webp_count'] = $count;
	    		
	    		if($image_sizes[$k]['compressed_count'] > $image_sizes[$k]['count'])
	    			$image_sizes[$k]['compressed_count'] = $image_sizes[$k]['count'];

	    		if($image_sizes[$k]['restored_count'] > $image_sizes[$k]['count'])
	    			$image_sizes[$k]['restored_count'] = $image_sizes[$k]['count'];

	    		if($image_sizes[$k]['restored_count'] > $image_sizes[$k]['count'])
	    			$image_sizes[$k]['webp_count'] = $image_sizes[$k]['count'];

	    		$image_sizes[$k]['compressed_saved'] = (int)get_option('compressed_saved_'.$k, 0);

	    		if($image_sizes[$k]['compressed_count'] > 0)
	    			$image_sizes[$k]['percent_done'] =  ceil($image_sizes[$k]['compressed_count']/$image_sizes[$k]['count'] * 100);
	    		else
	    			$image_sizes[$k]['percent_done'] = 0;		

	    		if($image_sizes[$k]['restored_count'] > 0)
	    			$image_sizes[$k]['restored_percent_done'] =  ceil($image_sizes[$k]['restored_count']/$image_sizes[$k]['count'] * 100);
	    		else
	    			$image_sizes[$k]['restored_percent_done'] = 0;	

	    		if($image_sizes[$k]['webp_count'] > 0)
	    			$image_sizes[$k]['webp_percent_done'] =  ceil($image_sizes[$k]['webp_count']/$image_sizes[$k]['count'] * 100);
	    		else
	    			$image_sizes[$k]['webp_percent_done'] = 0;	

	    	}
	    }
	
	    return $image_sizes;
	}


	public static function  get_subdirectories($directory)
	{
		$directory = rtrim($directory, '/');
	    $glob = glob($directory . '/*');

	    if($glob === false)
	    {
	        return array();
	    }

	    return array_filter($glob, function($dir) {
	        return is_dir($dir);
	    });

	}

	public  static function get_root_folders(){

		return self::get_subdirectories(get_home_path());
	}

	public static function regenerate_image_meta($id_image){

		$file_path = get_attached_file( $id_image );

		if(!file_exists($file_path))
			return false;

		// Add WordPress 5.3 support for -scaled images size.
		if ( false !== strpos( $file_path, '-scaled.' ) && function_exists( 'wp_get_original_image_path' ) ) {
			$file_path = wp_get_original_image_path( $id_image );
		}

		// Generate all other image size, and update attachment metadata.
		$metadata = wp_generate_attachment_metadata( $id_image, $file_path );

		// Update metadata to db if it was successfully generated.
		if ( ! empty( $metadata ) && ! is_wp_error( $metadata ) ) {
			wp_update_attachment_metadata( $id_image, $metadata );
		}

		
	}


	public static function insert_webp_htaccess_rules(){

		$folder_prefix = '/';

		$urlparts = parse_url(home_url());
		$domain = $urlparts['host'];
		
		if(strlen($domain) > 1){
			$expl = explode($domain, home_url());
			$end = end($expl);
			if(strlen($end) > 1)
				$folder_prefix = '/'.trim($end,'/');
		}

		$convert_webp_status = (int)get_option('convert_webp_status', 0);
		$convert_change_extension = (int)get_option('convert_change_extension', 0);
		$aso_enable_gzip = (int)get_option('aso_enable_gzip', 0);
		$aso_enable_deflate = (int)get_option('aso_enable_deflate', 0);

	    $htaccess = get_home_path().".htaccess";

	    $lines = array();
	    $lines[] = 'RewriteRule . - [E=REWRITEBASE:'. $folder_prefix .']';
	    $lines[] = '# Apache 2.2';
	    $lines[] = '<IfModule !mod_authz_core.c>';
	    $lines[] = '    <Files ~ "(?i)^.*\.(webp)$">';
	    $lines[] = '        Allow from all';
	    $lines[] = '    </Files>';
	    $lines[] = '</IfModule>';
	    $lines[] = '';


	    $lines[] = '# Apache 2.4';
	    $lines[] = '<IfModule mod_authz_core.c>';
	    $lines[] = '    <Files ~ "(?i)^.*\.(webp)$">';
	    $lines[] = '        Require all granted';
	    $lines[] = '        allow from all';
	    $lines[] = '    </Files>';
	    $lines[] = '</IfModule>';
	    $lines[] = '';

	    $lines[] = '<IfModule mod_setenvif.c>';
	    $lines[] = 'SetEnvIf Request_URI "\.(jpe?g|png)$" REQUEST_image';
	    $lines[] = '</IfModule>';
	    $lines[] = '';

	    if($aso_enable_gzip = 1){
	    		$lines[] = '';

	    		$lines[] = '<IfModule mod_expires.c>';
                $lines[] = 'ExpiresActive On';
                $lines[] = 'ExpiresByType image/gif "access plus 1 year"';
                $lines[] = 'ExpiresByType image/jpeg "access plus 1 year"';
                $lines[] = 'ExpiresByType image/png "access plus 1 year"';
                $lines[] = 'ExpiresByType image/webp "access plus 1 year"';
                $lines[] = 'ExpiresByType text/css "access plus 1 week"';
                $lines[] = 'ExpiresByType text/javascript "access plus 1 week"';
                $lines[] = 'ExpiresByType application/javascript "access plus 1 week"';
                $lines[] = 'ExpiresByType application/x-javascript "access plus 1 week"';
                $lines[] = 'ExpiresByType image/x-icon "access plus 1 year"';
                $lines[] = 'ExpiresByType image/svg+xml "access plus 1 year"';
                $lines[] = 'ExpiresByType image/vnd.microsoft.icon "access plus 1 year"';
                $lines[] = 'ExpiresByType application/font-woff "access plus 1 year"';
                $lines[] = 'ExpiresByType application/x-font-woff "access plus 1 year"';
                $lines[] = 'ExpiresByType application/vnd.ms-fontobject "access plus 1 year"';
                $lines[] = 'ExpiresByType font/opentype "access plus 1 year"';
                $lines[] = 'ExpiresByType font/ttf "access plus 1 year"';
                $lines[] = 'ExpiresByType font/otf "access plus 1 year"';
                $lines[] = 'ExpiresByType application/x-font-ttf "access plus 1 year"';
                $lines[] = 'ExpiresByType application/x-font-otf "access plus 1 year"';
                $lines[] = 'ExpiresByType text/xml "access plus 1 seconds"';
                $lines[] = 'ExpiresByType text/plain "access plus 1 seconds"';
                $lines[] = 'ExpiresByType application/xml "access plus 1 seconds"';
                $lines[] = 'ExpiresByType application/rss+xml "access plus 1 seconds"';
                $lines[] = 'ExpiresByType application/json "access plus 1 seconds"';
                $lines[] = '</IfModule>';
	    		$lines[] = '';
	    }

	    if($aso_enable_deflate  == 1){
	    	  $lines[] = '';
              $lines[] = '<IfModule mod_deflate.c>';
              $lines[] = 'AddOutputFilterByType DEFLATE application/javascript';
              $lines[] = 'AddOutputFilterByType DEFLATE application/rss+xml';
              $lines[] = 'AddOutputFilterByType DEFLATE application/vnd.ms-fontobject';
              $lines[] = 'AddOutputFilterByType DEFLATE application/x-font';
              $lines[] = 'AddOutputFilterByType DEFLATE application/x-font-opentype';
              $lines[] = 'AddOutputFilterByType DEFLATE application/x-font-otf';
              $lines[] = 'AddOutputFilterByType DEFLATE application/x-font-truetype';
              $lines[] = 'AddOutputFilterByType DEFLATE application/x-font-ttf';
              $lines[] = 'AddOutputFilterByType DEFLATE application/x-javascript';
              $lines[] = 'AddOutputFilterByType DEFLATE application/xhtml+xml';
              $lines[] = 'AddOutputFilterByType DEFLATE application/xml';
              $lines[] = 'AddOutputFilterByType DEFLATE font/opentype';
              $lines[] = 'AddOutputFilterByType DEFLATE font/otf';
              $lines[] = 'AddOutputFilterByType DEFLATE font/ttf';
              $lines[] = 'AddOutputFilterByType DEFLATE image/svg+xml';
              $lines[] = 'AddOutputFilterByType DEFLATE image/x-icon';
              $lines[] = 'AddOutputFilterByType DEFLATE text/css';
              $lines[] = 'AddOutputFilterByType DEFLATE text/html';
              $lines[] = 'AddOutputFilterByType DEFLATE text/javascript';
              $lines[] = 'AddOutputFilterByType DEFLATE text/plain';
              $lines[] = 'AddOutputFilterByType DEFLATE text/xml';
              $lines[] = '</IfModule>';
              $lines[] = '';
	    }

        //Check browser compatibility from .htacces
        if((int)$convert_webp_status > 0 && (int)$convert_change_extension == 0 )
        {
             $lines[] = '';
             $lines[] = '<IfModule mod_rewrite.c>';
             $lines[] = 'RewriteEngine On';
             $lines[] = 'RewriteBase '.$folder_prefix;
             $lines[] = 'RewriteCond %{HTTP_ACCEPT} image/webp';
             $lines[] = 'RewriteCond %{REQUEST_FILENAME} (.*)\.(jpe?g|png)$';
             $lines[] = 'RewriteCond %1\.webp -f';
             $lines[] = 'RewriteRule (.+)\.(jpe?g|png)$ $1.webp [T=image/webp,E=accept:1]';
             $lines[] = '</IfModule>';

             $lines[] = '';
             $lines[] = '<IfModule mod_rewrite.c>';
             $lines[] = 'RewriteEngine On';
             $lines[] = 'RewriteCond %{HTTP_ACCEPT} image/webp';
             $lines[] = 'RewriteCond %{DOCUMENT_ROOT}/$1.webp -f';
             $lines[] = 'RewriteRule (.+)\.(jpe?g|png)$ $1.webp [T=image/webp]';
             $lines[] = '</IfModule>';
        }

        $lines[] = '';
        $lines[] = '<IfModule mod_headers.c>';
        $lines[] = 'Header append Vary Accept env=REDIRECT_accept';
        $lines[] = '</IfModule>';
        $lines[] = '';

        $lines[] = '<IfModule mod_mime.c>';
        $lines[] = 'AddType image/webp .webp';
        $lines[] = '</IfModule>';

	    insert_with_markers($htaccess, "ASO-WEBP", $lines);
	}

	public static function remove_webp_htaccess_rules(){

   		$htaccess = get_home_path().".htaccess";
    	insert_with_markers($htaccess, "ASO-WEBP", '');
	}

	public static function get_image( $offset = 0, $order = 'ASC' )
	{

		$query_img_args = array(  
		    'post_type' => 'attachment',  
		    'post_mime_type' =>array(  
		                    'jpg|jpeg|jpe' => 'image/jpeg',  
		                    'gif' => 'image/gif',  
		        'png' => 'image/png',  
		        ),  
		    'post_status' => 'inherit',  
		    'posts_per_page' => 1,  
		    'orderby' => 'ID',
		    'order' => $order, // This must be ASC, to first compress older images so new ones can be compressed also
		    'offset' => $offset
		    );  

		$query_img = new WP_Query( $query_img_args );
		wp_reset_query();
		

		if(!$query_img)
			return false;

		return $query_img->posts[0];

		
	}

	public static function attachment_count() {

		global $wpdb;    
		$result = $wpdb->get_results( "SELECT count(*) as count FROM `".$wpdb->prefix."posts` WHERE post_type = 'attachment' AND post_mime_type IN ('image/jpeg', 'image/gif', 'image/png') ", ARRAY_A );
		
		if(!$result)
			return 0;
			
		return $result[0]['count'];
		

	}

	public static function get_url_content($url)
	{
		$curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, FALSE);
		curl_setopt($curl, CURLOPT_COOKIEFILE, "cookie.txt");
		curl_setopt($curl, CURLOPT_COOKIEJAR, "cookie.txt");
		curl_setopt($curl, CURLOPT_HEADER, false);
		curl_setopt($curl, CURLOPT_ENCODING, "");
		curl_setopt($curl, CURLOPT_TIMEOUT, 3);
		curl_setopt($curl, CURLOPT_MAXREDIRS, 8);
		$contents = curl_exec($curl);
		curl_close($curl);

		if(!$contents || empty($contents))
		{
			return false;
		}

		return $contents;
	}

	public static function get_optimized_image($img_src, $quality = 70)
	{
		if($quality < 60)
			 $quality = 60;

		$service = 'http://api.resmush.it/ws.php?qlty='.$quality.'&img=';
		$o = json_decode(self::get_url_content($service . urlencode($img_src)), true);

		if($o == NULL){
			return array('error' => true, 'message' => esc_attr('ReSmush could not compress the image.'));
		}

		if(isset($o->error) )
		{
			return array('error' => true, 'message' => esc_attr($o->error));
		}
		else
			return array('error' => false, 'object' => $o);
	}

	public static function convert_all_sizes_of_image($image_id = NULL)
	{
		if($image_id == NULL)
			return false;

		$all_image_sizes = Advanced_Speed_Optimizer_Functions::get_all_image_sizes();
		$quality = (int)get_option('convert_webp_quality', 70);

	
		if($all_image_sizes) {
			foreach($all_image_sizes as $k => $image_size) {
				$answer = self::convert_image_size($image_id, $k, $quality);
			}
		}
	}

	public static function compress_all_sizes_of_image($image_id = NULL)
	{
		if($image_id == NULL)
			return false;

		$all_image_sizes = Advanced_Speed_Optimizer_Functions::get_all_image_sizes();
		$compression_quality = (int)get_option('compression_quality', 70);

		if($all_image_sizes) {
			foreach($all_image_sizes as $k => $image_size) {
				$answer = self::compress_image_size($image_id, $k, $compression_quality);
				if($answer['error'] == false) {
					$current_quality_saved = (int)get_option('compressed_saved_'.$k, 0);
					$new_saved = (int)$current_quality_saved  +  ceil(( (int)$answer['object']['src_size'] - (int)$answer['object']['dest_size'] ) /1024) ;
					update_option('compressed_saved_'.$k, $new_saved) ;		
				}
			}
		}
	}

	public static function get_image_path($id_image, $image_size = NULL) {

	    $image = wp_get_attachment_image_src($id_image, $image_size);
	    $imagepath = str_replace(get_site_url(), $_SERVER['DOCUMENT_ROOT'], $image[0]);

	    if($imagepath) 
	    	return $imagepath;

	    return false;
	}

	public static function create_image_backup($id_image = NULL,  $image_size = NULL, $path = NULL)
	{
		if($id_image == NULL && $path == NULL)
			return false;

		if($id_image != NULL){
			$file_path = self::get_image_path($id_image, $image_size);

			if($file_path && file_exists($file_path) && !file_exists($file_path.'.aso.bak')){
				$content = file_get_contents($file_path);
				file_put_contents($file_path.'.aso.bak', $content);
				unset($content);
			}
		}

		if($path != NULL){
			if($path && file_exists($path) && !file_exists($path.'.aso.bak')){
				$content = file_get_contents($path);
				file_put_contents($path.'.aso.bak', $content);
				unset($content);
			}
		}
	}

	public static function compress_image_size($image = NULL, $image_size = NULL, $quality = 70)
	{

		if(is_numeric($image))
		{
			 $new_image = (object) [
					    'ID' => $image
		  	];
			
			$image = $new_image;
		}

		$image_info = self::get_image_src($image, $image_size);
		
		if(!$image || $image_info['error'])
		{
			return array(
							'error' => true,
							'message' => esc_html__('Image does not exist on the server', Advanced_Speed_Optimizer::$plugin_slug)
						);
		}

		if($image_size != NULL && $image_size != 'original' & $image_size != 'full')
		{
			$image_info_original = self::get_image_src($image, 'original');
			
			if($image_info['path'] == $image_info_original['path']){
				return array(
							'error' => true,
							'message' => esc_html__('The current image size does not exist for this image', Advanced_Speed_Optimizer::$plugin_slug)
						);
			}
		}

		$compression_backup = (int)get_option('compression_backup', 0);
	
		if($compression_backup == 1)
			self::create_image_backup($image->ID, $image_size);

		$compressed_image = self::get_optimized_image($image_info['src'], $quality);

		if($compressed_image['error'])
			return array(
							'error' => true,
							'message' => esc_html__($compressed_image['message'], Advanced_Speed_Optimizer::$plugin_slug)
						);

		if($compressed_image['object']['percent'] > 0 && is_writable($image_info['path']))
		{
			$image_compressed = self::get_url_content($compressed_image['object']['dest']);
			if($image_compressed)
			{
				$im = imagecreatefromstring($image_compressed );

				if ($im !== false) {
					file_put_contents($image_info['path'], $image_compressed);	
				    imagedestroy($im);
				    
				    return array(
				    	'error' => false,
				    	'object' => $compressed_image['object']
				    );
				}
			}
		}
	}

	public static function compress_image_by_folder($image_path, $image_url = NULL){

		if(!$image_url){
			$aso_root_dir = rtrim(get_home_path(),'/');
			$aso_domain_url =  rtrim(get_site_url(),'/');
			$image_url = str_replace($aso_root_dir, $aso_domain_url , $image_path);
		}

		$quality = (int)get_option('compression_quality', 70);
		$compression_backup = (int)get_option('compression_backup', 0);

		//if($compression_backup == 1)
		//	self::create_image_backup(NULL, NULL, $image_path);

		$compressed_image = self::get_optimized_image($image_url, $quality);

		if($compressed_image['error'])
				return array(
								'error' => true,
								'message' => esc_html__($compressed_image['message'], Advanced_Speed_Optimizer::$plugin_slug)
							);

		if(!is_writable($image_path))
			return array(
								'error' => true,
								'message' => esc_html__('Image is not writable. Please change writing permissions', Advanced_Speed_Optimizer::$plugin_slug)
							);

		if($compressed_image['object']['percent'] > 0)
		{
			$image_compressed = self::get_url_content($compressed_image['object']['dest']);

			if($image_compressed)
			{
				$im = imagecreatefromstring($image_compressed );

				if ($im !== false) {
					file_put_contents($image_path, $image_compressed);	
					   imagedestroy($im);
				}
			}
		}

		if($compressed_image['object'] === NULL)
		{
			return array(
								'error' => true,
								'message' => esc_html__('ReSmush.it could not compress the image.', Advanced_Speed_Optimizer::$plugin_slug)
							);

		}


		return array(
			'error' => false,
			'object' => $compressed_image['object']
		);


	}

	public static function get_webp_from_advancedplugins($path = NULL, $image_type = 'image_file_b64', $quality = 85)
	{

		if($path == NULL)
			return false;

		$urlparts = parse_url(home_url());
		$domain = $urlparts['host'];
		$ch = curl_init();
		$data = array(
						'action' => 'convert2webp',
						'token'  => 'codecanyon-pro-version',
						'q'      => $quality,
						'site_url' => $domain,
						'cc-key' => get_option('cc_key', ''),
						$image_type => $path,
		);

		curl_setopt($ch, CURLOPT_URL,"https://api.advancedplugins.com/codecanyon/codecanyon-webp-conversion.php");
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

		// Receive server response ...
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
		curl_setopt($ch, CURLOPT_VERBOSE, TRUE);
		//curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type: image/jpeg"));

		curl_setopt($ch, CURLOPT_HEADER, false);
		curl_setopt($ch, CURLOPT_ENCODING, "");
		
		curl_setopt($ch, CURLOPT_TIMEOUT, 6);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 6); 
		curl_setopt($ch, CURLOPT_MAXREDIRS, 3);

		$server_output = curl_exec($ch);

		curl_close ($ch);

		if(!$server_output)
		{
			return false;
		}

		if (substr_count($server_output, 'WEBPVP8') == 0) {
	       return false;
	    }

		$im = getimagesizefromstring($server_output);

		return $server_output;
	}

	public static function verify_activation_from_advancedplugins()
	{

		$urlparts = parse_url(home_url());
		$domain = $urlparts['host'];
		
		$ch = curl_init();
		$data = array(
						'action' => 'verify-codecanyon-purchase',
						'token'  => 'codecanyon-pro-version',
						'site_url' => $domain,
						'cc-key' => get_option('cc_key', '')
		);

		curl_setopt($ch, CURLOPT_URL,"https://api.advancedplugins.com/codecanyon/codecanyon-verification.php");
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

		// Receive server response ...
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
		curl_setopt($ch, CURLOPT_VERBOSE, TRUE);
		//curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type: image/jpeg"));

		curl_setopt($ch, CURLOPT_HEADER, false);
		curl_setopt($ch, CURLOPT_ENCODING, "");
		
		curl_setopt($ch, CURLOPT_TIMEOUT, 6);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 6); 
		curl_setopt($ch, CURLOPT_MAXREDIRS, 3);

		$server_output = curl_exec($ch);


		curl_close ($ch);

		if(!$server_output)
		{
			return false;
		}

		return json_decode($server_output, true);
	}

	public static function convert_image_to_webp($image_path = NULL, $quality = 70)
	{
		if(!$image_path)
			return false;

		$imagewebp = function_exists('imagewebp');
		$imagick = extension_loaded('imagick');
		$is_imagick = false;

		if($imagick)
		{
			if(class_exists('Imagick'))
			{
				$formats = Imagick::queryFormats();
				foreach($formats as $format)
				{
					if(strtoupper($format) == 'WEBP')
						$is_imagick = true;
				}
			}
		}

		$webp_path =  str_replace(array('.jpg', '.png', '.jpeg','.JPG','.PNG','.JPEG'), '.webp', $image_path);
		$image = self::get_webp_from_advancedplugins(base64_encode(file_get_contents($image_path)), 'image_file_b64',  $quality);

		if($image){
			file_put_contents($webp_path, $image);

			if(file_exists($webp_path))
			{
				$compressed_image = array();
				$compressed_image['object'] = array('src_size' => filesize($image_path) , 'dest_size' => filesize($webp_path) );
				return array(
					'error' => false,
					'object' => $compressed_image['object']
				);
			}	
		}


		return array(
				'error' => true,
				'message' => esc_html__('Image was not converted', Advanced_Speed_Optimizer::$plugin_slug)
			);
	}

	public static function convert_image_size($image = NULL, $image_size = NULL, $quality = 70)
	{

		if(is_numeric($image))
		{
			 $new_image = (object) [
					    'ID' => $image
		  	];
			
			$image = $new_image;
		}

		$image_info = self::get_image_src($image, $image_size);

		if(!$image || $image_info['error'])
		{
			return array(
							'error' => true,
							'message' => esc_html__('Image does not exist on the server', Advanced_Speed_Optimizer::$plugin_slug)
						);
		}

		if($image_size != NULL && $image_size != 'original' & $image_size != 'full')
		{
			$image_info_original = self::get_image_src($image, 'original');
			
			if($image_info['path'] == $image_info_original['path']){
				return array(
							'error' => true,
							'message' => esc_html__('The current image size does not exist for this image', Advanced_Speed_Optimizer::$plugin_slug)
						);
			}
		}
	
		self::convert_image_to_webp($image_info['path'], $quality);
		
	}

	public static function get_image_src($image, $image_size = NULL){
		
		if(is_numeric($image))
		{
			 $new_image = (object) [
					    'ID' => $image
		  	];
			
			$image = $new_image;
		}

		if(!$image || !isset($image->ID) )
			return array(
							'error' => true,
							'message' => esc_html__('No image was found', Advanced_Speed_Optimizer::$plugin_slug)
						);

		$upload_dir = wp_upload_dir();
		$size_src = wp_get_attachment_image_src($image->ID, $image_size);


		if(empty($size_src))
			return array(
							'error' => true,
							'message' => esc_html__('Image does not exist on the server', Advanced_Speed_Optimizer::$plugin_slug)
						);

		$size_src = $size_src[0];
		$src_parse = parse_url ( $size_src ); 

		if(empty($src_parse))
			return array(
							'error' => true,
							'message' => esc_html__('Image does not exist on the server', Advanced_Speed_Optimizer::$plugin_slug)
						);

		$src_path = str_replace('//','/',get_home_path().$src_parse ['path']);
		
		if(!file_exists($src_path))
			return array(
							'error' => true,
							'message' => esc_html__('Image does not exist on the server', Advanced_Speed_Optimizer::$plugin_slug)
						);	

		return array('error' => false, 'src' => esc_url($size_src), 'path' => esc_url($src_path));
	}

	public static function compress_image_sizes($image_sizes = array())
	{
		
		if(empty($image_sizes))
			return false;

		$quality = (int)get_option('compression_quality', 70);
		$compression_arr = array();

		$images_compressed = array();

		foreach($image_sizes as $image_size) {
			$current_offset = (int)get_option('compressed_offset_'.$image_size, 0);
			$image = self::get_image($current_offset);
			$image_info = self::get_image_src($image);
			$compression_arr[$image_size] = array('compressed_saved' => 0);
			update_option('compressed_offset_'.$image_size, (int)$current_offset  + 1);

			$current_quality_saved = (int)get_option('compressed_saved_'.$image_size, 0);
			$compression_arr[$image_size]['compressed_saved'] = $current_quality_saved;
			$compression_arr[$image_size]['new_offset'] = (int)$current_offset  + 1;

			if($image && !$image_info['error'])
			{
				if(!in_array($image->ID, $images_compressed)){
					$images_compressed[] = $image->ID;
				}

				$answer = self::compress_image_size($image, $image_size, $quality);
				if($answer['error'] == false)
				{
					$new_saved = (int)$current_quality_saved  +  ceil(( (int)$answer['object']['src_size'] - (int)$answer['object']['dest_size'] ) /1024) ;
					$compression_arr[$image_size]['compressed_saved'] = $new_saved;
					update_option('compressed_saved_'.$image_size, $new_saved) ;

				}
			}
		}
 
		if(!empty($images_compressed)){
			foreach($images_compressed as $id_image){
				self::regenerate_image_meta($id_image);
			}
		}

		return $compression_arr;
	}

	public static function convert_image_sizes($image_sizes = array())
	{
		
		if(empty($image_sizes))
			return false;

		$quality = (int)get_option('convert_webp_quality', 70);
		$compression_arr = array();

		$images_webp = array();

		foreach($image_sizes as $image_size) {
			$current_offset = (int)get_option('webp_offset_'.$image_size, 0);
			$image = self::get_image($current_offset);
			$image_info = self::get_image_src($image);
			$compression_arr[$image_size] = array('webp_saved' => 0);
			update_option('webp_offset_'.$image_size, (int)$current_offset  + 1);

			$current_quality_saved = (int)get_option('webp_saved_'.$image_size, 0);
			$compression_arr[$image_size]['webp_saved'] = $current_quality_saved;
			$compression_arr[$image_size]['new_offset'] = (int)$current_offset  + 1;

			if($image && !$image_info['error'])
			{
				if(!in_array($image->ID, $images_webp)){
					$images_webp[] = $image->ID;
				}

				$answer = self::convert_image_size($image, $image_size, $quality);
				
			}
		}
 
		return $compression_arr;
	}


	public static function restore_image_backup($image = NULL, $image_size = NULL, $path = NULL)
	{

		if(is_numeric($image))
		{
			 $new_image = (object) [
					    'ID' => $image
		  	];
			
			$image = $new_image;
		}

		if(!$image || $image_info['error'])
		{
			return array(
							'error' => true,
							'message' => esc_html__('Image does not exist on the server', Advanced_Speed_Optimizer::$plugin_slug)
						);
		}

		if($image->ID == NULL && $path == NULL)
			return false;

		if($image->ID != NULL){
			$file_path = self::get_image_path($image->ID, $image_size);

			if($file_path && file_exists($file_path.'.aso.bak')){
				$content = file_get_contents($file_path.'.aso.bak');
				file_put_contents($file_path, $content);
				unset($content);
			}
		}	
	}

	public static function remove_image_backup($image = NULL, $image_size = NULL, $path = NULL)
	{

		if(is_numeric($image))
		{
			 $new_image = (object) [
					    'ID' => $image
		  	];
			
			$image = $new_image;
		}


		if(!$image || $image_info['error'])
		{
			return array(
							'error' => true,
							'message' => esc_html__('Image does not exist on the server', Advanced_Speed_Optimizer::$plugin_slug)
						);
		}

		if($image->ID == NULL && $path == NULL)
			return false;

		if($image->ID != NULL){
			$file_path = self::get_image_path($image->ID, $image_size);
			
			if(file_exists($file_path.'.aso.bak')){
				unlink($file_path.'.aso.bak');
			}
		}	
	}

	public static function remove_bk_sizes($image_sizes = array())
	{
		
		if(empty($image_sizes))
			return false;

		$compression_arr = array();
		$images_compressed = array();

		foreach($image_sizes as $image_size) {
			$current_offset = (int)get_option('restored_offset_'.$image_size, 0);
			update_option('restored_offset_'.$image_size, (int)$current_offset  + 1);

			$compression_arr[$image_size]['compressed_saved'] = 0;
			$compression_arr[$image_size]['new_offset'] = (int)$current_offset  + 1;

			$image = self::get_image($current_offset);
			$image_info = self::get_image_src($image);


			if($image && !$image_info['error'])
			{
				if(!in_array($image->ID, $images_compressed)){
					$images_compressed[] = $image->ID;
				}

				$answer = self::remove_image_backup($image, $image_size);
				$compression_arr[$image_size]['compressed_saved'] = 0;


			}
		}

		return $compression_arr;
	}


	public static function restore_image_sizes($image_sizes = array())
	{
		
		if(empty($image_sizes))
			return false;

		$compression_arr = array();
		$images_compressed = array();

		foreach($image_sizes as $image_size) {
			$current_offset = (int)get_option('restored_offset_'.$image_size, 0);
			update_option('restored_offset_'.$image_size, (int)$current_offset  + 1);

			$compression_arr[$image_size]['compressed_saved'] = 0;
			$compression_arr[$image_size]['new_offset'] = (int)$current_offset  + 1;

			$image = self::get_image($current_offset);
			$image_info = self::get_image_src($image);


			if($image && !$image_info['error'])
			{
				if(!in_array($image->ID, $images_compressed)){
					$images_compressed[] = $image->ID;
				}

				$answer = self::restore_image_backup($image, $image_size);
				$compression_arr[$image_size]['compressed_saved'] = 0;
			}
		}

		if(!empty($images_compressed)){
			foreach($images_compressed as $id_image){
				self::regenerate_image_meta($id_image);
			}
		}

		return $compression_arr;
	}
}