/*
 * Advanced Plugins
 *
 *  @author Advanced Plugins
 *  @copyright  Advanced Plugins
 *  @website https://advancedplugins.com
 */

(function( $ ) {
	'use strict';


	$(function($) {

	    (function($, window, document, undefined) {
	        var $window = $(window);

	        $.fn.lazyload = function(options) {
	            var elements = this;
	            var $container;
	            var settings = {
	                threshold: 0,
	                failure_limit: 0,
	                event: "scroll.lazyload",
	                effect: "show",
	                container: window,
	                data_attribute: "src",
	                data_srcset: "srcset",
	                skip_invisible: false,
	                appear: null,
	                load: null,
	                trigger_class: null,
	                placeholder: "data:image/gif;base64,R0lGODdhAQABAPAAAMPDwwAAACwAAAAAAQABAAACAkQBADs="
	            };

	            function update() {
	                var counter = 0;

	                elements.each(function() {
	                    var $this = $(this);
	                    if (settings.skip_invisible && !$this.is(":visible")) {
	                        return;
	                    }
	                    if ($.abovethetop(this, settings) ||
	                        $.leftofbegin(this, settings)) {
	                        /* Nothing. */
	                    } else if (!$.belowthefold(this, settings) &&
	                        !$.rightoffold(this, settings)) {
	                        $this.trigger("appear");
	                        /* if we found an image we'll load, reset the counter */
	                        counter = 0;
	                    } else {
	                        if (++counter > settings.failure_limit) {
	                            return false;
	                        }
	                    }
	                });

	            }

	            if (options) {
	                /* Maintain BC for a couple of versions. */
	                if (undefined !== options.failurelimit) {
	                    options.failure_limit = options.failurelimit;
	                    delete options.failurelimit;
	                }
	                if (undefined !== options.effectspeed) {
	                    options.effect_speed = options.effectspeed;
	                    delete options.effectspeed;
	                }

	                $.extend(settings, options);
	            }

	            /* Cache container as $ as object. */
	            $container = (settings.container === undefined ||
	                settings.container === window) ? $window : $(settings.container);

	            /* Fire one scroll event per scroll. Not one scroll event per image. */
	            if (0 === settings.event.indexOf("scroll")) {
	                $container.off(settings.event).on(settings.event, function() {
	                    return update();
	                });
	            }

	            this.each(function() {
	                var self = this;
	                var $self = $(self);

	                self.loaded = false;

	                /* If no src attribute given use data:uri. */
	                if ($self.attr("src") === undefined || $self.attr("src") === false) {
	                    if ($self.is("img")) {
	                        $self.attr("src", settings.placeholder);
	                    }
	                }

	                /* When appear is triggered load original image. */
	                $self.one("appear", function() {
	                    if (!this.loaded) {
	                        if (settings.appear) {
	                            var elements_left = elements.length;
	                            settings.appear.call(self, elements_left, settings);
	                        }
	                        $("<img />")
	                            .one("load", function() {
	                                var original = $self.attr("data-" + settings.data_attribute);
	                                var srcset = $self.attr("data-" + settings.data_srcset);

	                                if (original !== $self.attr("src")) {
	                                    $self.hide();
	                                    if ($self.is("img")) {
	                                        $self.attr("src", original);
	                                        if (srcset !== null) {
	                                            $self.attr("srcset", srcset);
	                                        }
	                                    }
	                                    if ($self.is("video")) {
	                                        $self.attr("poster", original);
	                                    } 
	                                    $self[settings.effect](settings.effect_speed);
	                                }

	                                self.loaded = true;

	                                /* Remove image from array so it is not looped next time. */
	                                var temp = $.grep(elements, function(element) {
	                                    return !element.loaded;
	                                });
	                                elements = $(temp);

	                                if (settings.load) {
	                                    var elements_left = elements.length;
	                                    settings.load.call(self, elements_left, settings);
	                                }
	                            })
	                            .bind("error", function() {

	                                if (settings.trigger_class)
	                                    $(self).removeClass(settings.trigger_class);

	                                $(self).removeClass('asolazy');
	                                $(self).trigger("error");

	                            })
	                            .attr({
	                                "src": $self.attr("data-" + settings.data_attribute),
	                                "srcset": $self.attr("data-" + settings.data_srcset) || ""
	                            });
	                    }
	                });

	                /* When wanted event is triggered load original image */
	                /* by triggering appear.                              */
	                if (0 !== settings.event.indexOf("scroll")) {
	                    $self.off(settings.event).on(settings.event, function() {
	                        if (!self.loaded) {
	                            $self.trigger("appear");
	                        }
	                    });
	                }
	            });

	            /* Check if something appears when window is resized. */
	            $window.off("resize.lazyload").bind("resize.lazyload", function() {
	                update();
	            });

	            /* With IOS5 force loading images when navigating with back button. */
	            /* Non optimal workaround. */
	            if ((/(?:iphone|ipod|ipad).*os 5/gi).test(navigator.appVersion)) {
	                $window.on("pageshow", function(event) {
	                    if (event.originalEvent && event.originalEvent.persisted) {
	                        elements.each(function() {
	                            $(this).trigger("appear");
	                        });
	                    }
	                });
	            }

	            /* Force initial check if images should appear. */
	            $(function() {
	                update();
	            });

	            return this;
	        };

	        /* Convenience methods in $ namespace.           */
	        /* Use as  $.belowthefold(element, {threshold : 100, container : window}) */

	        $.belowthefold = function(element, settings) {
	            var fold;

	            if (settings.container === undefined || settings.container === window) {
	                fold = (window.innerHeight ? window.innerHeight : $window.height()) + $window.scrollTop();
	            } else {
	                fold = $(settings.container).offset().top + $(settings.container).height();
	            }

	            return fold <= $(element).offset().top - settings.threshold;
	        };

	        $.rightoffold = function(element, settings) {
	            var fold;

	            if (settings.container === undefined || settings.container === window) {
	                fold = $window.width() + $window.scrollLeft();
	            } else {
	                fold = $(settings.container).offset().left + $(settings.container).width();
	            }

	            return fold <= $(element).offset().left - settings.threshold;
	        };

	        $.abovethetop = function(element, settings) {
	            var fold;

	            if (settings.container === undefined || settings.container === window) {
	                fold = $window.scrollTop();
	            } else {
	                fold = $(settings.container).offset().top;
	            }

	            return fold >= $(element).offset().top + settings.threshold + $(element).height();
	        };

	        $.leftofbegin = function(element, settings) {
	            var fold;

	            if (settings.container === undefined || settings.container === window) {
	                fold = $window.scrollLeft();
	            } else {
	                fold = $(settings.container).offset().left;
	            }

	            return fold >= $(element).offset().left + settings.threshold + $(element).width();
	        };

	        $.inviewport = function(element, settings) {
	            return !$.rightoffold(element, settings) && !$.leftofbegin(element, settings) &&
	                !$.belowthefold(element, settings) && !$.abovethetop(element, settings);
	        };

	        /* Custom selectors for your convenience.   */
	        /* Use as $("img:below-the-fold").something() or */
	        /* $("img").filter(":below-the-fold").something() which is faster */

	        $.extend($.expr[":"], {
	            "below-the-fold": function(a) {
	                return $.belowthefold(a, {
	                    threshold: 0
	                });
	            },
	            "above-the-top": function(a) {
	                return !$.belowthefold(a, {
	                    threshold: 0
	                });
	            },
	            "right-of-screen": function(a) {
	                return $.rightoffold(a, {
	                    threshold: 0
	                });
	            },
	            "left-of-screen": function(a) {
	                return !$.rightoffold(a, {
	                    threshold: 0
	                });
	            },
	            "in-viewport": function(a) {
	                return $.inviewport(a, {
	                    threshold: 0
	                });
	            },
	            /* Maintain BC for couple of versions. */
	            "above-the-fold": function(a) {
	                return !$.belowthefold(a, {
	                    threshold: 0
	                });
	            },
	            "right-of-fold": function(a) {
	                return $.rightoffold(a, {
	                    threshold: 0
	                });
	            },
	            "left-of-fold": function(a) {
	                return !$.rightoffold(a, {
	                    threshold: 0
	                });
	            }
	        });

	    })($, window, document);


	    function trigger_recheck() {
	
	        if ($('.modal.in img.asolazy').length > 0) {
	            $('.modal.in img.asolazy').each(function() {
	                var el = $(this);
	                el.attr('src', el.attr('data-src'));
	                el.removeClass('asolazy');
		            if(el.attr('srcset')){
		            	el.attr('srcset',el.attr('data-srcset'));
		            }

	                el.attr({
	                    'data-asolazy': 1
	                });

	            });
	        }

	        $('.asolazy').each(function() {
	            var t = $(this);
	            if (t.is(':in-viewport')) {
	                t.attr('src', t.attr('data-src'));
	                t.removeClass('asolazy');
		            if(t.attr('srcset')){
		            	t.attr('srcset',t.attr('data-srcset'));
		            }

	                t.attr({
	                    'data-asolazy': 1
	                });
	            }

	        });

	    }

	    function lazyload_init() {

	        $("img.asolazy").lazyload({
	            load: function() {
	            var el = $(this);
	                el.attr({
	                    'data-asolazy': 1
	                });
	             el.removeClass('asolazy');
	            if(el.attr('srcset')){
	            	el.attr('srcset',el.attr('data-srcset'));
	            }

	            },
	            'trigger_class': 'asolazy'
	        });



	    }

	    $(window).on('load', function() {

	        $("img.asolazy").attr({
	            'data-asolazy': 0
	        });

	        lazyload_init();

	        setInterval(function() {
	            trigger_recheck();
	        }, 200);

	        $(document).ajaxSuccess(function() {
	            lazyload_init();
	        });

	        $(document).on("click", function() {
	            lazyload_init();
	        });

	    });

	});

})( jQuery );
